﻿<%@ Page Title="TBI Instruments - TBI Survey Summary" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="InstrumentSummaryNote.aspx.cs" Inherits="TBI_Instruments_InstrumentSummaryNote" MaintainScrollPositionOnPostback="true"%>
<%@ Import Namespace="VeteransAffairs.Registries.Business"%>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <style type="text/css">
        .style15
        {
            width: 1037px;
        }
    </style>
    
    <style type="text/css">
        .breadcrumbInstrument {
            background-color:#6B1424;
            border-bottom:1px solid #000;
            color:#FFF;
            font-family:Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant:small-caps;
            font-weight:700;
            letter-spacing:1px;
            margin: 2px 0 2px 0;
            padding:8px 25px 5px 10px;
        }
    </style>
    
    
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">

    <script type="text/javascript">

        function HandleButtons(button) {

            var btnSubmit = document.getElementById("<%=SubmitNoteButton.ClientID%>");
            var btnCancel = document.getElementById("<%=CancelButton.ClientID%>");

            //Disable Submit button to prevent user from clicking it while the form is being processed
            if (btnSubmit != null) {
                btnSubmit.disabled = true;

                //Set Submit button caption to indicate processing if the note was submitted to CPRS
                if (button == "Submit" && btnSubmit.value == "Submit Note") {
                    btnSubmit.value = "Submitting...";
                }
            }

            //Disable Cancel button to prevent user from clicking it while the form is being processed
            if (btnCancel != null) {
                btnCancel.disabled = true;
            }

            return;
        }
        
    </script>
    
    <div id="skiplink">
        <a href="#content">skip to page content</a>
    </div>
    <asp:Menu 
        ID="Menu2" 
        runat="server" 
        SkipLinkText="Skip Left Navigation Links"
        DynamicHorizontalOffset="2"  Width="166px" 
        StaticMenuItemStyle-CssClass = "leftMenuItem"  
        DynamicMenuItemStyle-CssClass = "leftMenuItem"  
        StaticDisplayLevels="3" Height="134px" 
        onmenuitemclick="Menu2_MenuItemClick" >
        <StaticHoverStyle CssClass= "leftMenuItemHover" />
        <DynamicHoverStyle CssClass= "leftMenuItemHover" />
    </asp:Menu>

    <div class="breadcrumbInstrument">
                <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > TBI Survey Summary"></asp:Label> 
            </div>
            <br /> 
            
    <center>        
    <asp:Panel ID="PanelPatient" Width="80%"
                  GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
            <table cellpadding = "5" cellspacing = "5" width = "100%">
                <tr>
                    <td>
                         &nbsp;&nbsp;<asp:Label ID = "LabelForName" runat = "server" Text = "Patient:" AssociatedControlID = "LabelPatient"></asp:Label>       
                        &nbsp;<asp:Label ID="LabelPatient" runat="server" SkinID="DataLabel">Patient One Hundred and Four</asp:Label>
                    </td>
                    <td>
                        <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID = "LabelSSN" Text = "SSN:"></asp:Label>
                        &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel"></asp:Label>
                    
                    </td>
                    <td>
                        <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID = "LabelFacility" Text = "Facility:" Visible="false"></asp:Label>
                        &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel"></asp:Label>
                    
                    </td>
                </tr>
            </table>
            </asp:Panel>
    </center>
    <br />           
    <div>
            
        <asp:Literal ID = "SurveyNoteHTML" runat = "server"></asp:Literal>
    <center>
    <asp:Panel ID = "ErrorPanel" runat = "server" Visible = "false">
        <h2 style = "font-size:large;color:Red" >
            <asp:Literal ID = "SurveyNoteError" runat = "server"></asp:Literal> 
        </h2>
    </asp:Panel>     
    </center>
    </div>
    <br />
    <br />
    <br />
    <center> 
    <asp:Panel ID = "ButtonsPanel" runat = "server">   
        <asp:Button ID = "SubmitNoteButton" runat = "server" 
            OnClientClick="HandleButtons('Submit');"                      
            UseSubmitBehavior = "false"  
            Text = "Submit Note" 
            Width = "130px" OnClick = "SubmitNote_Click"/>
        <asp:Button ID = "CancelButton" runat = "server" 
            OnClientClick="HandleButtons('Cancel');"                      
            UseSubmitBehavior = "false" 
            Text = "Cancel" 
            Width = "130px" CssClass = "cancel" />
        <asp:Button ID = "btnCancelIOCNote" runat = "server" 
            Visible="false"
            Text = " Cancel" 
            Width = "130px"
            OnClick="RemovePotentialIOCNote_Click" />
        <br />
        <br />
        <asp:Label ID="Label8" runat="server" SkinID="DataLabel">
            Please review the content.  If you need to make changes, click the Cancel button and edit the answers. If the content is correct,<br />
            click the Submit Note button.<br /><br />

            Note: Once the note is submitted, it will no longer be editable in this tool and updates will need to be done within CPRS.
        </asp:Label>
        <br />   
   </asp:Panel>  
    </center>
</asp:Content> 